let currentTheme = 'default';
let selectedTheme = 'default';

document.addEventListener('DOMContentLoaded', function() {
    // Load current theme
    chrome.storage.sync.get('sparxTheme', function(data) {
        currentTheme = data.sparxTheme || 'default';
        selectedTheme = currentTheme;
        updateUI();
    });

    // Theme selection
    document.querySelectorAll('.theme-card').forEach(card => {
        card.addEventListener('click', function() {
            selectedTheme = this.getAttribute('data-theme');
            updateSelection();
        });
    });

    // Apply button
    document.getElementById('apply-btn').addEventListener('click', function() {
        applyTheme(selectedTheme);
    });
});

function updateSelection() {
    // Update card states
    document.querySelectorAll('.theme-card').forEach(card => {
        const isSelected = card.getAttribute('data-theme') === selectedTheme;
        card.classList.toggle('active', isSelected);
    });

    // Update apply button text if changing theme
    const applyBtn = document.getElementById('apply-btn');
    if (selectedTheme === currentTheme) {
        applyBtn.innerHTML = '<span class="btn-icon">✅</span>Current Theme';
        applyBtn.style.background = 'linear-gradient(135deg, #48bb78, #38a169)';
    } else {
        applyBtn.innerHTML = '<span class="btn-icon">✨</span>Apply Theme';
        applyBtn.style.background = 'linear-gradient(135deg, #667eea, #764ba2)';
    }
}

function applyTheme(theme) {
    currentTheme = theme;
    selectedTheme = theme;
    
    // Save theme preference
    chrome.storage.sync.set({ sparxTheme: theme }, function() {
        console.log('Theme saved:', theme);
    });

    // Apply to current Sparx tab
    applyThemeToCurrentTab(theme);

    updateUI();
    
    // Show confirmation animation
    showConfirmation();
}

function applyThemeToCurrentTab(theme) {
    chrome.tabs.query({active: true, currentWindow: true}, function(tabs) {
        if (tabs[0] && isSparxTab(tabs[0].url)) {
            chrome.tabs.sendMessage(tabs[0].id, {
                action: 'applyTheme',
                theme: theme
            });
        }
    });
}

function updateUI() {
    // Update current theme display
    const themeNames = {
        'default': 'Classic',
        'hacker': 'Hacker Terminal',
        'ocean': 'Ocean Blue',
        'nature': 'Forest Nature',
        'sunset': 'Warm Sunset',
        'space': 'Space Galaxy'
    };
    
    document.getElementById('current-theme').textContent = themeNames[currentTheme];
    updateSelection();
}

function showConfirmation() {
    const applyBtn = document.getElementById('apply-btn');
    const originalHtml = applyBtn.innerHTML;
    
    applyBtn.innerHTML = '<span class="btn-icon">🎉</span>Applied!';
    applyBtn.style.background = 'linear-gradient(135deg, #48bb78, #38a169)';
    
    setTimeout(() => {
        updateUI();
    }, 1500);
}

function isSparxTab(url) {
    if (!url) return false;
    return url.includes('sparx');
}

// Add some interactive effects
document.addEventListener('DOMContentLoaded', function() {
    // Add hover effects to theme cards
    const cards = document.querySelectorAll('.theme-card');
    cards.forEach((card, index) => {
        card.style.animationDelay = `${index * 0.1}s`;
    });
});